<?php

namespace App\Policies;

use App\Models\BL;
use App\Models\User;
use App\Models\OfficeUser;
use Illuminate\Auth\Access\Response;

class BLPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User | OfficeUser $user, BL $bl): Response
    {
        if(auth()->user()->is_customer()) {
            if (auth()->user()->organization_id !== $bl->organization_id) {
                return Response::deny('You do not have permission to edit this BL. Please contac to our admin if you still need to edit this BL.');
            }
        }
        return Response::allow();
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return true;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User | OfficeUser $user, BL $bl): Response
    {
        $timediff = \Carbon\Carbon::parse($bl->created_at);
        $now = \Carbon\Carbon::parse(\Carbon\Carbon::now());

        if(auth()->user()->is_customer()) {
            if($bl->locked || $bl->editing_time <=  $timediff->diffInSeconds($now)) {
                return Response::deny('This BL has exceded the time limit of modification action. Please contac to our admin if you still need to edit this BL.');
            }
            if (auth()->user()->organization_id !== $bl->organization_id) {
                return Response::deny('You do not have permission to edit this BL. Please contac to our admin if you still need to edit this BL.');
            }
        }
        return Response::allow();
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, BL $bl): Response
    {
        if(auth()->user()->is_customer()) {
            return Response::deny('You do not have permission to Delete this BL. Please contac to our admin if you still need to DELETE this BL.');
        }
        return Response::allow();
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, BL $bl): bool
    {
        if(auth()->user()->is_customer()) {
            return false;
        }
        return true;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, BL $bL): bool
    {
        if(auth()->user()->is_customer()) {
            return false;
        }
        return true;
    }
}
