<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trackings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bl_id')->nullable()->constrained('billofladings')->cascadeOnUpdate()->cascadeOnDelete();
            $table->date('date')->nullable()->useCurrent();
            $table->foreignId('status_id')->nullable()->nullOnDelete();
            // $table->enum('status', ['port_arrived', 'port_ready_to_ship', 'port_transshipment', 'port_way_to', 'on_board', 'warehouse_inside', 'warehouse_loading', 'warehouse_unloading'])->default('warehouse_inside');
            $table->string('status_details')->nullable();
            $table->text('description')->nullable();
            $table->foreignId('port_id')->nullable()->constrained()->cascadeOnUpdate()->nullOnDelete();
            $table->foreignId('vessel_id')->nullable()->constrained()->cascadeOnUpdate()->nullOnDelete();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trackings');
    }
};
