<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Enums\Colors;
use App\Enums\Statuses;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        \App\Models\OfficeUser::factory()->create([
            'name' => 'Kawsar',
            'email' => 'kawsar@sealloyd.com',
        ]);
        $this->command->info('Office User Kawsar (kawsar@sealloyd.com) has been created.');

        \App\Models\OfficeUser::factory()->create([
            'name' => 'Admin',
            'email' => 'admin@admin.com',
        ]);
        $this->command->info('Office User Admin (admin@admin.com) has been created.');

        \App\Models\Office::factory(10)->create();
        $this->command->info('10 Offices Seeding Completed.');

        \App\Models\Organization::factory(5)->create();
        $this->command->info('5 Organization Seeding Completed.');

        \App\Models\User::factory()->create([
            'name' => 'Customer',
            'email' => 'test@test.com',
            'organization_id' => 1,
        ]);
        $this->command->info('Customer (test@test.com) has been created.');

        \App\Models\User::factory()->create([
            'name' => 'Customer',
            'email' => 'test@test2.com',
            'organization_id' => 2,
        ]);
        $this->command->info('Customer (test@test2.com) has been created.');

        \App\Models\User::factory()->create([
            'name' => 'Customer',
            'email' => 'test@test3.com',
            'organization_id' => 3,
        ]);
        $this->command->info('Customer (test@test3.com) has been created.');

        \App\Models\User::factory()->create([
            'name' => 'Customer',
            'email' => 'test@test4.com',
            'organization_id' => 4,
        ]);
        $this->command->info('Customer (test@test4.com) has been created.');

        \App\Models\User::factory()->create([
            'name' => 'Customer',
            'email' => 'test@test5.com',
            'organization_id' => 5,
        ]);
        $this->command->info('Customer (test@test5.com) has been created.');

        // \App\Models\User::factory(100)->create();
        // $this->command->info('100 User Seeding Completed.');


        $statuses = Statuses::cases();
        $colors = Colors::cases();
        for ($i=0; $i < count($statuses); $i++) { 
            \App\Models\Status::factory()->create([
                'status' => $statuses[$i],
                'color' => $colors[$i],
            ]);
        }
        $this->command->info('Status has been added.');


        \App\Models\Depot::factory(20)->create();
        $this->command->info('20 Depots Seeding Completed.');

        \App\Models\VesselOperator::factory(20)->create();
        $this->command->info('20 VesselOperator Seeding Completed.');

        \App\Models\Vessel::factory(100)->create();
        $this->command->info('100 Vessel Seeding Completed.');

        \App\Models\Container::factory(100)->create();
        $this->command->info('100 Container Seeding Completed.');

        \App\Models\Company::factory(100)->create();
        $this->command->info('100 Company Seeding Completed.');

        
        \App\Models\Billoflading::factory(20)->create();
        $this->command->info('20 Billoflading Seeding Completed.');

        \App\Models\Bl_container::factory(200)->create();
        $this->command->info('200 Bl_container Seeding Completed.');

        \App\Models\Tracking::factory(200)->create();
        $this->command->info('200 Tracking Seeding Completed.');


        \App\Models\BL::factory(20)->create();
        $this->command->info('20 Billoflading (string) Seeding Completed.');

        \App\Models\BlContainer::factory(200)->create();
        $this->command->info('200 Bl_container (string) Seeding Completed.');
    }
}
