<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>BILL OF LANDING</title>
    
    <link rel="stylesheet" href="<?php echo e(asset('css/bl/styles.css')); ?>">

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dom-to-image/2.6.0/dom-to-image.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.5/jspdf.min.js"></script>

    <?php
        $bl_bg = '';
        $left = 0;
        if (isset($data[1]) && $data[1] != false) {
            $bl_bg = 'background: url('. asset('bl-bg.jpg') .') no-repeat -40px -10px;background-size: 800px;position: relative;';
            $left = -20;
        }
    ?>

    <?php if(isset($_GET['print'])): ?>
        <script>
            window.print();
        </script>
    <?php endif; ?>

    <style>
        body {
            font-family: "Consolas", sans-serif;
            font-size: 11px;
            min-height: 1080px;
        }
        .delivery_agent {
            text-align: initial;
            max-width: initial;
            width: 350px;
        }
        .prepaid {
            width: 120px;
        }
        .c1 {
            left: calc(40px + <?php echo e($left); ?>px);
        }
        .c3 {
            left: 190px;
        }
        .c4 {
            left: 260px;
        }
        .c5 {
            left: 339px;
        }
        .c7 {
            left: 435px;
        }
        .c8 {
            left: 515px;
        }
        .c9 {
            left: 600px;
        }
        .c10 {
            left: 645px;
        }
        .c11 {
            left: 685px;
        }
        .row1 {
            top: 60px;
        }
        .row2 {
            top: 150px;
        }
        .row3 {
            top: 244px;
        }
        .row4 {
            top: 288px;
        }
        .row5 {
            top: 338px;
        }
        .row6 {
            top: 380px;
        }
        .row7 {
            top: 418px;
        }
        .row8 {
            top: 473px;
        }
        .row10 {
            top: 810px;
        }
        .row11 {
            top: 965px;
        }
        .place_issue {
            min-width: 260px;
        }
    </style>

</head>
<body style="<?php echo $bl_bg; ?>">
    <?php
    // dd($data);
    $info = isset($bl)?$bl:(!empty($data)?$data[0]:false);
    // dd($info);

    // dd($bl->discription_of_goods);

    // dd($bl_containers = $info->bl_containers);
    $bl_containers = $info->bl_containers;
    // dd(count($bl_containers))
    ?>


    <div id="content2">
        <div class="shipper row1 c1">
            <div><strong><?php echo e($info->shipper_data->name); ?></strong></div>
            <div><?php echo e($info->shipper_data->address); ?></div>
            <div><?php echo e($info->shipper_data->city->name); ?> - <?php echo e($info->shipper_data->post_code); ?>, <?php echo e($info->shipper_data->country->name); ?></div>
        </div>

        <div class="consignee row2 c1">
            <div><strong><?php echo e($info->consignee_data->name); ?></strong></div>
            <div><?php echo e($info->consignee_data->address); ?></div>
            <div><?php echo e($info->consignee_data->city->name); ?> - <?php echo e($info->consignee_data->post_code); ?>, <?php echo e($info->consignee_data->country->name); ?></div>
        </div>

        <div class="notify_party row3 c1">
            <div><strong><?php echo e($info->notify_party_data->name); ?></strong></div>
            <div><?php echo e($info->notify_party_data->address); ?></div>
            <div><?php echo e($info->notify_party_data->city->name); ?> - <?php echo e($info->notify_party_data->post_code); ?>, <?php echo e($info->notify_party_data->country->name); ?><?php if(!empty($info->notify_party2_data)): ?> * <?php endif; ?></div>
        </div>

        <div class="delivery_agent row4 c7">
            <div><strong><?php echo e($info->delivery_agent_data->name); ?></strong></div>
            <div><?php echo e($info->delivery_agent_data->address); ?></div>
            <div><?php echo e($info->delivery_agent_data->city->name); ?> - <?php echo e($info->delivery_agent_data->post_code); ?>, <?php echo e($info->delivery_agent_data->country->name); ?></div>
            <div>Tel: <?php echo e($info->delivery_agent_data->tel); ?>

                <?php if(!empty($info->delivery_agent_data->mobile)): ?>
                , <?php echo e($info->delivery_agent_data->mobile); ?>

                <?php endif; ?>
            </div>
            <?php if(!empty($info->delivery_agent_data->primary_email)): ?>
            <div>
                Email: <?php echo e($info->delivery_agent_data->primary_email); ?>

            </div>
            <?php endif; ?>
        </div>

        <!--Row 5-->
        <div class="pre_carriage_vessel row5 c1"><?php echo e($info->pre_carriage_vessel_data->name); ?>&nbsp;</div>
        
        <div class="voy_no row5 c3"><?php echo e($info->voy_no_pre_carriage); ?>&nbsp;</div>
        <div class="place_of_receipt row5 c4"><strong><?php echo e($info->place_of_receipt_data->name); ?>, <?php echo e($info->place_of_receipt_data->country->name); ?></strong></div>

        <!--Row 6-->
        <div class="ocean_vessel row6 c1"><strong><?php echo e($info->ocean_vessel_data->name); ?></strong></div>
        <div class="voy_no_destination row6 c3"><strong>V.<?php echo e($info->voy_no_destination); ?></strong></div>
        <div class="place_of_loading row6 c4"><strong><?php echo e($info->place_of_loading_data->name); ?>, <?php echo e($info->place_of_loading_data->country->name); ?></strong></div>
        <div class="booking_ref_no row6 c7"><?php echo e($info->booking_ref_no); ?>&nbsp;</div>
        <div class="bl_no row6 c9"><strong><?php echo e($info->bl_no); ?></strong></div>


        <!--Row 7-->
        <div class="port_of_discharge row7 c1"><strong><?php echo e($info->port_of_discharge_data->name); ?>, <?php echo e($info->port_of_discharge_data->country->name); ?></strong></div>
        <div class="final_destination row7 c4"><strong><?php echo e($info->final_destination_data->name); ?>, <?php echo e($info->final_destination_data->country->name); ?></strong></div>
        <div class="shipper_ref row7 c7"><?php echo e($info->shipper_ref); ?></div>
        <div class="original_bl row7 c9"><strong><?php echo e($info->original_bl); ?></strong></div>

        <!--Row 8-->
        <div class="container_info row8 c1">
            <strong>CONTAINER / SEAL NO</strong><br>
            <?php if(count($bl_containers) > 5): ?>
                AS PER RIDER

                <?php echo $info->container_info; ?>


                <?php if(!empty($info->notify_party2_data)): ?>
                    <div class="notify_party2">
                        <strong>* <?php echo e($info->notify_party2_data->name); ?></strong>
                        <div><?php echo e($info->notify_party2_data->address); ?></div>
                        <div><?php echo e($info->notify_party2_data->city->name); ?> - <?php echo e($info->notify_party2_data->post_code); ?>, <?php echo e($info->notify_party2_data->country->name); ?></div>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <?php $__currentLoopData = $bl_containers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $container): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($container->container->container_no); ?> / <?php echo e($container->seal_no); ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php echo $info->container_info; ?>

            <?php endif; ?>
        </div>
        <div class="qty row8 c4"><strong><?php echo e($info->qty); ?></strong></div>
        <div class="discription_of_goods row8 c5">
            
            <?php echo $info->discription_of_goods; ?>

        </div>
        <div class="weight row8 c9"><strong><?php echo e($info->weight); ?></strong></div>
        <div class="measurement row8 c11"><strong><?php echo e($info->measurement); ?></strong></div>

        <!--Row 9-->
        

        <!--Row 10-->
        <div class="freight_info row10 c1">
            <div><strong>FREIGHT <?php echo e($info->freight_type); ?></strong></div>
            <?php 
            // $fc = htmlspecialchars_decode($info->freight_and_charges);
            // $fc = html_entity_decode($fc);
            ?>  
            
            <?php echo $info->freight_and_charges; ?>

        </div>
        <div class="revenue_tons row10 c4"><?php echo e($info->revenue_tons); ?></div>
        <div class="rate row10 c6"><?php echo e($info->rate); ?></div>
        <div class="prepaid row10 c8"><strong><?php echo e($info->prepaid); ?></strong></div>
        <div class="collect row10 c10"><?php echo e($info->collect); ?></div>

        <!--Row 11-->
        <div class="ex_rate row11 c1"><?php echo e($info->ex_rate); ?></div>
        <div class="prepaid2 row11 c3"><strong><?php echo e($info->prepaid2); ?></strong></div>
        <div class="payable_at row11 c5"><strong><?php echo e($info->payable_at_data->name); ?>, <?php echo e($info->final_destination_data->country->name); ?></strong></div>
        <div class="place_issue row11 c8"><strong><?php echo e($info->place_issue_data->name); ?>, <?php echo e($info->final_destination_data->country->name); ?> <?php echo e(date("d/m/Y", strtotime($info->issue_date))); ?></strong></div>


        <!-- --------------------- Page 2 ----------------------->
        <!-- ---------- rowP2_title ------------>
        <div class="rowP2_title c3"><strong>ATTACHED SHEET OF BL# <?php echo e($info->bl_no); ?></strong></div>
        <div class="rowP2_body c1">

            <?php if(count($bl_containers) > 5): ?>
                <h3 class="title">Rider Sheet</h3>
                <table>
                    <tr>
                        <td width="30%">Bill of Lading No</td>
                        <td> : </td>
                        <td width="67%"><?php echo e($info->bl_no); ?></td>
                    </tr>
                    <tr>
                        <td width="30%">Vessel Name</td>
                        <td> : </td>
                        <td width="67%">
                            <?php echo e(!empty($info->ocean_vessel_data)?($info->ocean_vessel_data->name . ' (V.'. $info->voy_no_destination .')'):(!empty($info->pre_carriage_vessel_data)?$info->pre_carriage_vessel_data->name:'No vessel selected')); ?>

                        </td>
                    </tr>
                </table>
            <?php endif; ?>
            
            <?php echo $info->discription_of_goods2; ?>

        </div>
    </div>

    <?php if(isset($_GET['pdf']) && $_GET['pdf']>0){ ?>
    <script>
        domtoimage.toPng(document.getElementById('content2')).then(function (blob) {
            var pdf = new jsPDF('l', 'pt', [$('#content2').width(), $('#content2').height()]);

            // pdf.addImage(blob, 'PNG', 0, 0, $('#content2').width(), $('#content2').height());
            pdf.save("<?=$id?>.pdf");

            // that.options.api.optionsChanged();
        });
    </script>
    <?php } ?>

</body>
</html><?php /**PATH /Users/asaduzzamansardar/Herd/customer-bl/resources/views/billofladings/print.blade.php ENDPATH**/ ?>