<?php

namespace App\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum ContainerPropertyTypes: string implements HasLabel, HasColor, HasIcon
{
    case OWN = "own";
    case LEASING = "leasing";
    case NA = "na";

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    // public static function forSelect(): array 
    // {
    //     return array_combine(
    //         array_column(self::cases(), 'value'),
    //         array_column(self::cases(), 'name')
    //     );
    // }
    
    public function getLabel(): ?string
    {
        return match ($this) {
            self::OWN => "Own",
            self::LEASING => "Leasing",
            self::NA => "N/A",
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::OWN => 'secondary',
            self::LEASING => 'primary',
            self::NA => "gray",
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::OWN => 'heroicon-m-check',
            self::LEASING => 'heroicon-m-eye',
            self::NA => 'heroicon-m-x-mark',
        };
    }
}