<?php

namespace App\Filament\Office\Resources\ContainerResource\RelationManagers;

use Carbon\Carbon;
use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Model;
use App\Enums\ContainerEvents;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Resources\RelationManagers\RelationManager;

class HistoryRelationManager extends RelationManager
{
    protected static string $relationship = 'history';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                // Forms\Components\Select::make('transection_type')
                //     ->options([
                //         'purchased' => 'Purchased',
                //         'sold' => 'Sold',
                //         'leasing_on_hire' => 'On Hire (Leasing)',
                //         'leasing_off_hire' => 'Off Hire (Leasing)',
                //     ])
                //     ->searchable()
                //     ->required(),

                Forms\Components\Select::make('event')
                    ->options(ContainerEvents::class)
                    ->default('on_hire')
                    ->required()
                    ->searchable(),
                Forms\Components\DatePicker::make('at')->default(today()),
                Forms\Components\Select::make('from')
                    ->relationship('from_company', 'name')
                    ->searchable(),
                Forms\Components\Select::make('depot')
                    ->relationship('depot_company', 'name')
                    ->searchable(),
                Forms\Components\Select::make('pickup_location')
                    ->relationship('pickup_location_port', 'name')
                    ->searchable(),
                Forms\Components\RichEditor::make('ref'),

                // $table->timestamp('at')->useCurrent();
                // $table->foreignId('from')->nullable()->constrained('companies')->cascadeOnUpdate()->nullOnDelete();

                // $table->foreignId('depot')->nullable()->constrained('companies')->cascadeOnUpdate()->nullOnDelete();
                // $table->foreignId('pickup_location')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
                // $table->string('ref')->nullable();
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('container.container_no')
            ->columns([
                // Tables\Columns\TextColumn::make('container.container_no'),
                Tables\Columns\TextColumn::make('event')
                    // ->formatStateUsing(fn(string $state):string => match ($state) {
                    //     'purchased' => 'Purchased',
                    //     'sold' => 'Sold',
                    //     'leasing_on_hire' => 'On Hire (Leasing)',
                    //     'leasing_off_hire' => 'Off Hire (Leasing)',
                    // })
                    // ->badge()
                    // ->color(fn (string $state): string => match ($state) {
                    //     'purchased' => 'gray',
                    //     'sold' => 'warning',
                    //     'leasing_on_hire' => 'success',
                    //     'leasing_off_hire' => 'danger',
                    // })
                    // ->description(fn(?Model $record):string => Carbon::parse($record->at)->diffForHumans())
                    ->description(function(?Model $record):string {
                        $from_company_label = ($record->transection_type != 'sold')?'From ':'To ';
                        // if ($record->transection_type == 'sold') {
                        //     $from_company_label .= 'To ';
                        // }
                        $from_company_label .= $record->from_company->name;
                        $desc = $from_company_label . ' ⋅ ' . Carbon::parse($record->at)->diffForHumans();
                        
                        return $desc;
                    })
                    // ->label('Transection')
                    ->sortable()
                    ->searchable(),
                // Tables\Columns\TextColumn::make('at')->since(),
                // Tables\Columns\TextColumn::make('from_company.name'),
                Tables\Columns\TextColumn::make('depot_company.name')
                    ->label('Depot'),
                Tables\Columns\TextColumn::make('pickup_location_port.name')
                    ->label('Pickup Location'),
                Tables\Columns\TextColumn::make('ref')
                    ->html(),
            ])
            ->modifyQueryUsing(fn (Builder $query) => $query->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]))
            ->filters([
                Tables\Filters\TrashedFilter::make(),
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
                Tables\Actions\ForceDeleteAction::make(),
                Tables\Actions\RestoreAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                    Tables\Actions\ForceDeleteBulkAction::make(),
                    Tables\Actions\RestoreBulkAction::make(),
                ]),
            ]);
    }
}
