<?php

namespace App\Filament\Office\Resources\PortResource\Pages;

use Filament\Actions;
use App\Models\Country;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Office\Resources\PortResource;

class EditPort extends EditRecord
{
    protected static string $resource = PortResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $country = Country::select('name')->where('id', $data['country_id'])->first();
        $data['country_name'] = !empty($country)?$country->name:null;
    
        return $data;
    }
}
