<?php

namespace App\Filament\Resources\BLResource\Pages;

use Filament\Actions;
use App\Models\Office;
use Filament\Actions\Action;
use App\Filament\Resources\BLResource;
use Illuminate\Database\Eloquent\Model;
use Filament\Resources\Pages\EditRecord;

class EditBL extends EditRecord
{
    protected static string $resource = BLResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('pdf')
                ->label('PDF')
                ->url(fn (?Model $record): string => route('shipping.bl.pdf', $record->bl))
                ->icon('heroicon-o-document')
                // ->color('success')
                ->openUrlInNewTab(),
            
            Action::make('print')
                ->url(fn (?Model $record): string => route('shipping.bl.print', $record->bl))
                ->icon('heroicon-o-printer')
                ->openUrlInNewTab(),
                
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $office = Office::where('city_id', $data['final_destination_city_id'])->first();
        $data['delivery_agent_id'] = $office?$office->id:null;

        $data['last_updated_by_user_id'] = auth()->id();
    
        return $data;
    }

    public function getTitle(): string
    {
        return 'Edit ' . $this->getRecordTitle() . ' #' . $this->getRecord()->bl_no;
    }
}
