<?php

namespace App\Filament\Resources\BillofladingResource\Pages;

use App\Models\Port;
use Filament\Actions;
use App\Models\Billoflading;
use Filament\Actions\Action;
use Filament\Actions\ActionGroup;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Resources\BillofladingResource;

class EditBilloflading extends EditRecord
{

    protected static string $resource = BillofladingResource::class;

    protected function getHeaderActions(): array
    {
        return [
            ActionGroup::make([
                Action::make('send-email')
                    ->label('Send Email')
                    // ->url(fn (Billoflading $record): string => route('filament.admin.resources.shipping.billofladings.print', $record))
                    ->url(fn (Billoflading $record): string => route('shipping.billofladings.email', $record))
                    ->icon('heroicon-o-envelope')
                    // ->color('info')
                    ->openUrlInNewTab(),
                
                Action::make('pdf')
                    ->label('PDF')
                    // ->url(fn (Billoflading $record): string => route('filament.admin.resources.shipping.billofladings.print', $record))
                    ->url(fn (Billoflading $record): string => route('shipping.billofladings.pdf', $record))
                    ->icon('heroicon-o-document')
                    // ->color('success')
                    ->openUrlInNewTab(),
                
                Action::make('print')
                    // ->url(fn (Billoflading $record): string => route('filament.admin.resources.shipping.billofladings.print', $record))
                    ->url(fn (Billoflading $record): string => route('shipping.billofladings.print', $record))
                    ->icon('heroicon-o-printer')
                    ->openUrlInNewTab(),
            ]),

            Actions\DeleteAction::make()->icon('heroicon-o-trash'),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        if ($this->getRecord()->locked) {
            Notification::make()
                ->warning()
                ->title('This Bill of Lading is locked')
                ->body('If you need to edit this BL, you can contact our admin to unlock it.')
                ->persistent()
                // ->actions([
                //     Action::make('subscribe')
                //         ->button()
                //         ->url(route('subscribe'), shouldOpenInNewTab: true),
                // ])
                ->send();
    
            // $this->halt();
        }
        return $data;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $delivery_agent = Port::where('id', $data['port_of_discharge'])->with('office')->first()->office;

        $delivery_agent = !is_null($delivery_agent)?$delivery_agent->id:null;
        $data['delivery_agent_id'] = $delivery_agent;

        $data['last_updated_by'] = auth()->id();
    
        return $data;
    }
}
