<?php

namespace App\Http\Controllers;

use App\Models\BL;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;

class BLController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id, Request $request)
    {
        // dd($id, $request->has('print'));
        $bl = BL::where('bl', $id)->with([
            'port_of_discharge',
            'place_of_loading',
            'delivery_agent',
            'bl_containers',
        ])->withoutGlobalScopes([
            // SoftDeletingScope::class,
            'organization',
            'office'
        ])->firstOrFail();
        // dd($bl);

        // dd(Storage::directories('/bls/'));
        if(!Storage::exists('/bls/'.$id)) {
            Storage::makeDirectory('/bls/'.$id, 0777, true);
        }
        $bg = true;
        $data = [$bl, true];
        $pdf_name  = 'bl-'.$bl->bl_no.'-'.time().'.pdf';

        if ($request->has('pdf')) {
            $pdf_name = $this->getPdfName($bl->bl_no);
            $pdf = $this->pdf($bl, false);
            // // exit;
            // return view('bls.pdf', compact(['data', 'bg']));

            // $pdf = Pdf::loadView('bls.pdf-low-res', compact(['data', 'bg']))->setPaper([0.0, 0.0, 598, 850], 'potrait')->setOption(['dpi' => 200]);
            return $pdf->stream($pdf_name);
            // return $pdf->download($pdf_name);
        }

        if ($request->has('email')) {
            // $pdf = Pdf::loadView('bls.pdf', compact('data'))->setPaper('a4', 'potrait')->setOption(['dpi' => 150]);
            $pdf = Pdf::loadView('bls.pdf', compact(['data', 'bg']))->setPaper([0.0, 0.0, 598, 850], 'potrait')->setOption(['dpi' => 200]);
            // return $pdf->stream($pdf_name);
            // return view('bls.pdf', compact('data'));
            // return $pdf->save(storage_path('app/bls/'.$id).'/'.$pdf_name)->stream($pdf_name);
            return $pdf->download($pdf_name);
        }

        $bg = false;

        $pdf = Pdf::loadView('bls.pdf', compact(['data', 'bg']))->setPaper([0.0, 0.0, 598, 850], 'potrait')->setOption(['dpi' => 200]);
        return $pdf->stream($pdf_name);
        // exit;
        // return view('bls.print', compact('bl'));
    }

    function pdf(BL $bl, $highRes = false) {
        $view = $highRes?'bls.pdf':'bls.pdf-low-res';
        $dpi = $highRes?200:96;
        $bg = resource_path('images/bl/bl-front-low-res.jpg');

        return Pdf::loadView($view, compact(['bl', 'bg']))->setPaper([0.0, 0.0, 598, 850], 'potrait')->setOption(['dpi' => $dpi]);
    }

    function getPdfName($bl_no = '0') : string {
        return 'bl-'.$bl_no.'-'.time().'.pdf';
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
