<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OfficeStaff extends Model
{
    use HasFactory;

    /**
     * Get the office that owns the OfficeStaff
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function office(): BelongsTo
    {
        return $this->belongsTo(Office::class);
    }

    /**
     * Get the office_user that owns the OfficeStaff
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function office_user(): BelongsTo
    {
        return $this->belongsTo(OfficeUser::class);
    }
}
