<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Organization extends Model
{
    use HasFactory, SoftDeletes;
    
    /**
     * The "booted" method of the model.
     */
    protected static function booted(): void
    {
        // dd(auth()->user()->office);
        // dd(OfficeUser::where('id', auth()->user()->id)->with('office')->get());
        // static::addGlobalScope('office', function (Builder $builder) {
        //     $builder->where('office_id', auth()->user()->organization_id);
        // });
    }

    /**
     * Get all of the users for the Organization
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }
}
