<?php

namespace App\Observers;

use App\Models\Billoflading;
use App\Mail\BillofladingCreated;
use Illuminate\Support\Facades\Mail;
use Filament\Notifications\Notification;
use Filament\Notifications\Actions\Action;

class BillofladingObserver
{
    /**
     * Handle the Billoflading "created" event.
     */
    public function created(Billoflading $billoflading): void
    {
        $body = '#' . $billoflading->bl_no;
        Notification::make()
            ->title('A new Bill of Lading has created successfully')
            ->success()
            ->body($body)
            ->actions([
                Action::make('markAsUnread')
                    ->button()
                    ->markAsUnread(),
            ])
            ->send();
        
        // Mail::to('itskawsar41@gmail.com')->send(new BillofladingCreated($billoflading));
    }

    /**
     * Handle the Billoflading "updated" event.
     */
    public function updated(Billoflading $billoflading): void
    {
        $body = '#' . $billoflading->bl_no;
        Notification::make()
            ->title('The Bill of Lading has updated successfully')
            ->success()
            ->body($body)
            ->actions([
                Action::make('markAsUnread')
                    ->button()
                    ->markAsUnread(),
            ])
            ->send();
        
        // Mail::to('itskawsar41@gmail.com')->send(new BillofladingCreated($billoflading));
    }

    /**
     * Handle the Billoflading "deleted" event.
     */
    public function deleted(Billoflading $billoflading): void
    {
        //
    }

    /**
     * Handle the Billoflading "restored" event.
     */
    public function restored(Billoflading $billoflading): void
    {
        //
    }

    /**
     * Handle the Billoflading "force deleted" event.
     */
    public function forceDeleted(Billoflading $billoflading): void
    {
        //
    }
}
