<?php

namespace Database\Factories;

use Illuminate\Support\Arr;
use Illuminate\Support\Str;
use App\Enums\ContainerSizes;
use Illuminate\Database\Eloquent\Factories\Factory;
use App\Enums\BLTypes;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Billoflading>
 */
class BillofladingFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'company_id' => rand(1, 100),
            'warehouse_id' => rand(1, 100),
            'bl_no' => rand(10, 99) . time() . rand(10, 99),
            'bl_type' => Arr::random(BLTypes::cases()),
            // 'bl_status' => Arr::random(['On the way', 'On bord', 'Delivered', 'Empty Returned', 'Discharged', 'Waiting to load', 'Waiting to sail', 'Waiting for Discharge', 'Waiting for delivered']),
            'bl_status' => rand(1, 11),
            'etd' => fake()->date("Y-m-d", mt_rand(1262055681,1262055681)),
            'eta' => fake()->date("Y-m-d", mt_rand(1262055681,1262055681)),

            'shipper' => rand(1, 100),
            'consignee' => rand(1, 100),
            'notify_party' => rand(1, 100),
            'delivery_agent_id' => rand(1, 10),
            
            'container_tues' => rand(11, 999),
            
            'pre_carriage_vessel' => rand(1, 100),
            'voy_no_pre_carriage' => explode('-', fake()->uuid())[0],
            'place_of_receipt' => rand(1, 100),
            'ocean_vessel' => rand(1, 100),
            'voy_no_destination' => explode('-', fake()->uuid())[0],
            'place_of_loading' => rand(1, 100),
            'booking_ref_no' => explode('-', fake()->uuid())[0],
            'port_of_discharge' => rand(1, 100),
            'final_destination' => rand(1, 100),
            'shipper_ref' => explode('-', fake()->uuid())[0],
            'original_bl' => 1,
            'container_info' => fake()->regexify('[A-Z]{5}[0-4]{3}'),
            'qty' => rand(2,99),
            'discription_of_goods' => "<p>SHIPPER’S LOAD, STOW AND COUNT&nbsp;<br>(". rand(1, 25) ."X". Arr::random(ContainerSizes::values()) .") ". Arr::random(['FCL', 'LCL']) ." CONTAINER&nbsp;<br>STC:". rand(1234, 9900) ." CTNS( ONE THOUSAND<br>SEVEN&nbsp; HUNDRED THIRTY&nbsp;<br>FOUR CARTONS ONLY)<br>DESCRIPTION OF GOODS<br>READY MADE GARMENTS<br>T-SHIRT COMFY COTTON RC/RR2619<br>SUPERIR COTTON RC/RR2619<br>SUPER COTTON RC/RR2619<br>STYLE NO: CT51,CT52, CT54, CT60 &amp;<br>&nbsp;CT71 COLOUR: MIXED&nbsp;<br>HS CODE: 61091000&nbsp;<br>INV NO&nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; ZSG/ORS/14/2023 &nbsp;<br>DATE : 10-09-2023<br>S.CONT NO :&nbsp; ZSG-ORS-51-2022 &nbsp;<br>DATE : 15-07-2022<br>EXP NO&nbsp; &nbsp; &nbsp; &nbsp;: 0862-018619-2023&nbsp; &nbsp;&nbsp;<br>DATE : 10-09-2023</p>",
            'discription_of_goods2' => "<p>SHIPPER’S LOAD, STOW AND COUNT&nbsp;<br>(1X40'HC)FCL CONTAINER&nbsp;<br>STC:1734 CTNS( ONE THOUSAND<br>SEVEN&nbsp; HUNDRED THIRTY&nbsp;<br>FOUR CARTONS ONLY)<br>DESCRIPTION OF GOODS<br>READY MADE GARMENTS<br>T-SHIRT COMFY COTTON RC/RR2619<br>SUPERIR COTTON RC/RR2619<br>SUPER COTTON RC/RR2619<br>STYLE NO: CT51,CT52, CT54, CT60 &amp;<br>&nbsp;CT71 COLOUR: MIXED&nbsp;<br>HS CODE: 61091000&nbsp;<br>INV NO&nbsp; &nbsp; &nbsp; &nbsp;:&nbsp; ZSG/ORS/14/2023 &nbsp;<br>DATE : 10-09-2023<br>S.CONT NO :&nbsp; ZSG-ORS-51-2022 &nbsp;<br>DATE : 15-07-2022<br>EXP NO&nbsp; &nbsp; &nbsp; &nbsp;: 0862-018619-2023&nbsp; &nbsp;&nbsp;<br>DATE : 10-09-2023</p>",
            'weight' => rand(200, 9999) . ' kgs',
            'net_weight' => rand(200, 9999) . ' tons',
            'measurement' => rand(200, 9999) . ' m3',
            
            'freight_type' => Arr::random(['prepaid', 'postpaid', 'collect']),
            'freight_and_charges' => Str::random(rand(4,10)),
            
            'revenue_tons' => Str::random(1),
            'rate' => rand(111, 999),
            'prepaid' => rand(111, 999),
            'collect' => rand(111, 999),
            'ex_rate' => rand(90, 160),
            'prepaid2' => rand(111, 999),
            'payable_at' => rand(1, 100),
            'place_issue' => rand(1, 100),
            'issue_date' => fake()->date("Y-m-d", mt_rand(1262055681,1262055681)),


            'do_issued_at' => fake()->date("Y-m-d", mt_rand(1262055681,1262055681)),
            'do_online_id' => fake()->numerify('########'),
            'do_cnf_name' => fake()->name(),
            'do_cnf_license' => fake()->regexify('[A-Z]{5}[0-4]{3}'),


            'entry_by' => rand(1, 100),
            'last_updated_by' => rand(1, 100),
            'deleted_by' => rand(1, 100),

            'organization_id' => rand(1,5),
            'office_id' => rand(1,10),
        ];
    }
}
