<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\VesselOperator>
 */
class VesselOperatorFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $name = fake()->unique()->company();
        $words = explode(" ", str_replace('-', ' ', $name));
        $code = '';
        foreach($words as $word){
            $code .= $word[0].$word[1];
        }

        return [
            'name' => $name,
            'code' => strtoupper($code . fake()->randomLetter()),
            'address' => fake()->streetAddress(),
            'city_id' => rand(1, 100),
            'state_id' => rand(1, 100),
            'country_id' => rand(1, 100),
            'post_code' => fake()->postcode(),
            'website' => 'example.com',
            'primary_email' => fake()->email(),
            'tel' => fake()->phoneNumber(),
            'mobile' => fake()->phoneNumberWithExtension(),
            'note' => fake()->text(),
        ];
    }
}
