<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('organizations', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100);
            $table->string('code')->unique();
            $table->string('address', 200);
            $table->foreignId('city_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('state_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('country_id')->nullable()->constrained()->nullOnDelete();
            $table->string('post_code', 20)->nullable();
            $table->string('website', 100)->nullable();
            $table->string('email', 100)->nullable();
            $table->string('tel', 100)->nullable();
            $table->string('mobile', 100)->nullable();
            $table->text('note')->nullable();

            $table->date('start_date')->nullable();
            $table->string('timezone')->nullable();
            $table->integer('financial_year_start_month')->unsigned()->default(7);

            $table->integer('date_format')->unsigned()->default(2); // DD-MM-YYYY, MM-DD-YYYY, YYYY-MM-DD, MM/DD/YYYY, DD/MM/YYYY, YYYY/MM/DD, MM.DD.YYYY, DD.MM.YYYY, YYYY.MM.DD
            $table->integer('time_format')->unsigned()->default(2); // 12, 24
            $table->string('transaction_edit_days')->nullable();
            
            $table->foreignId('currency_id')->nullable()->constrained()->nullOnDelete();
            $table->string('vat_number')->nullable();

            $table->string('logo')->nullable();
            $table->string('invoice_logo')->nullable();
            $table->string('invoice_footer_logo')->nullable();
            $table->string('light_logo')->nullable();
            $table->string('dark_logo')->nullable();
            $table->string('favicon')->nullable();

            $table->json('licenses')->nullable();
            
            $table->foreignId('office_id')->nullable()->constrained()->nullOnDelete();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('organizations');
    }
};
