<?php

use App\Enums\BLTypes;
use App\Enums\ShipmentTypes;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('b_l_s', function (Blueprint $table) {
            $table->id();
            $table->ulid('bl')->unique();
            $table->foreignId('invoice_to_company_id')->nullable()->constrained('companies')->nullOnDelete();
            // $table->bigInteger('warehouse_id')->nullable()->unsigned();
            $table->string('bl_no');
            $table->bigInteger('bl_status')->unsigned()->default(1);
            $table->enum('bl_type', BLTypes::values())->default('draft');
            
            // $table->enum('shipment_type', ShipmentTypes::values())->default('fcl'); // disabling the enum for now
            $table->string('cargo_type')->default('lcl_fcl');
            $table->string('loading_type')->default('cy_cfs');

            // location_status
            $table->date('etd')->useCurrent();
            $table->date('eta')->useCurrent();

            // $table->string('shipper_name');
            // $table->string('shipper_address');
            // $table->string('consignee_name');
            // $table->string('consignee_address');
            // $table->string('notify_party_name');
            // $table->string('notify_party_address');
            // $table->string('notify_party2_name')->nullable();
            // $table->string('notify_party2_address')->nullable();
            $table->text('shipper');
            $table->text('consignee');
            $table->text('notify_party');
            $table->text('notify_party2')->nullable();

            $table->foreignId('delivery_agent_id')->nullable()->constrained('offices')->cascadeOnUpdate()->nullOnDelete();
            
            // $table->integer('container_tues')->unsigned()->nullable();
            
            $table->string('pre_carriage_vessel')->nullable();
            $table->string('voy_no_pre_carriage')->nullable();
            $table->string('ocean_vessel');
            $table->string('voy_no_destination');
            $table->bigInteger('place_of_loading_id')->nullable()->unsigned();
            $table->string('place_of_receipt');
            $table->bigInteger('port_of_discharge_id')->nullable()->unsigned();
            $table->string('final_destination');
            $table->string('final_destination_country_id')->nullable();
            $table->foreignId('final_destination_city_id')->nullable()->constrained('cities')->nullOnDelete();
            $table->string('shipper_ref')->nullable();
            $table->string('booking_ref_no')->nullable();
            $table->enum('original_bl', [0, 1, 2, 3])->nullable()->default(1);
            // $table->text('container_info')->nullable();
            $table->string('qty')->nullable();
            $table->text('discription_of_goods')->nullable();
            $table->text('rider_sheet')->nullable();
            $table->string('weight', 20)->nullable();
            $table->string('net_weight', 20)->nullable();
            $table->string('measurement', 20)->nullable();
            
            $table->enum('freight_type', ['prepaid', 'postpaid', 'collect'])->nullable()->default('prepaid');
            $table->text('freight_and_charges')->nullable();
            
            $table->string('revenue_tons')->nullable();
            $table->string('rate', 20)->nullable();
            $table->string('prepaid', 20)->nullable();
            $table->string('collect', 20)->nullable();
            $table->string('ex_rate', 20)->nullable();
            $table->string('prepaid2', 20)->nullable();
            $table->string('payable_at')->nullable();
            // $table->foreignId('payable_at')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            $table->string('place_issue')->nullable();
            // $table->foreignId('place_issue')->nullable()->constrained('ports')->cascadeOnUpdate()->nullOnDelete();
            $table->date('issue_date')->nullable()->useCurrent();
            $table->date('shipped_on_board')->nullable()->useCurrent();

            // $table->timestamp('do_issued_at')->useCurrent();
            // $table->string('do_online_id')->nullable();
            // $table->string('do_cnf_name')->nullable();
            // $table->string('do_cnf_license')->nullable();

            $table->string('editing_time')->default(24*60*60);
            $table->boolean('locked')->default(false);
            $table->boolean('is_final')->default(false);
            $table->boolean('completed')->default(false);

            $table->boolean('customer_created')->default(false);
            $table->integer('posted_user_type')->default(1)->comment('1=customer, 2=office, 3=others');
            $table->unsignedBigInteger('posted_by_user_id')->nullable();
            $table->unsignedBigInteger('last_updated_by_user_id')->nullable();
            
            $table->foreignId('final_by_user_id')->nullable()->constrained('office_users')->cascadeOnUpdate()->nullOnDelete();
            $table->foreignId('deleted_by_user_id')->nullable()->constrained('office_users')->cascadeOnUpdate()->nullOnDelete();

            $table->foreignId('office_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('organization_id')->nullable()->constrained();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('b_l_s');
    }
};
